


// #####################################
// #                                   #
// #       Klasse f. Bandmatizen       #
// #                                   #
// #####################################


class Bandmatrix
{
private:
  long n;  //Anz. der Datenpunkte
  long bw; //Anz. der Nebendiagonalen
  double **band;
public:
  Bandmatrix(long ndata,long bandbreite); //Konstruktor
  double r(long i,long j); //Lesen
  void w(double value,long i,long j);  //Schreiben
  ~Bandmatrix();  //Destruktor
};



//RECIPES
//

void rkck(double y[], double dydx[], long n, double x, double h,
        double yout[], double yerr[], void (*derivs)(double, double [], double [], double []));
void rkqs(double y[], double dydx[], double p[], long n, double *x,
	  double htry, double eps, double yscal[], double *hdid, double *hnext,long rkqs_ign,
        void (*derivs)(double, double [], double [], double []));

void svdcmp(double **a, int m, int n, double w[], double **v);
double pythag(double a, double b);
double ran1(long *idum);
double gasdev(long *idum);
double spline(double *x,double *g,double *gam,long n,double t);
void svbksb(double **u, double w[], double **v, int m, int n, double b[], double x[]);
void splines(double *x,double *y,double *w,long n,double alpha,double *g,double *gam);
void splines_gcv(double *x,double *y,double *w,long n,double *alpha,double *g,double *gam,double maxa);
//NRUTIL

static double sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)

static double dsqrarg;
#define DSQR(a) ((dsqrarg=(a)) == 0.0 ? 0.0 : dsqrarg*dsqrarg)

static double dmaxarg1,dmaxarg2;
#define DMAX(a,b) (dmaxarg1=(a),dmaxarg2=(b),(dmaxarg1) > (dmaxarg2) ?\
        (dmaxarg1) : (dmaxarg2))

static double dminarg1,dminarg2;
#define DMIN(a,b) (dminarg1=(a),dminarg2=(b),(dminarg1) < (dminarg2) ?\
        (dminarg1) : (dminarg2))

static double maxarg1,maxarg2;
#define FMAX(a,b) (maxarg1=(a),maxarg2=(b),(maxarg1) > (maxarg2) ?\
        (maxarg1) : (maxarg2))

static double minarg1,minarg2;
#define FMIN(a,b) (minarg1=(a),minarg2=(b),(minarg1) < (minarg2) ?\
        (minarg1) : (minarg2))

static long lmaxarg1,lmaxarg2;
#define LMAX(a,b) (lmaxarg1=(a),lmaxarg2=(b),(lmaxarg1) > (lmaxarg2) ?\
        (lmaxarg1) : (lmaxarg2))

static long lminarg1,lminarg2;
#define LMIN(a,b) (lminarg1=(a),lminarg2=(b),(lminarg1) < (lminarg2) ?\
        (lminarg1) : (lminarg2))

static int imaxarg1,imaxarg2;
#define IMAX(a,b) (imaxarg1=(a),imaxarg2=(b),(imaxarg1) > (imaxarg2) ?\
        (imaxarg1) : (imaxarg2))

static int iminarg1,iminarg2;
#define IMIN(a,b) (iminarg1=(a),iminarg2=(b),(iminarg1) < (iminarg2) ?\
        (iminarg1) : (iminarg2))

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

void nrerror(char error_text[]);
double *vector(long nl, long nh);
int *ivector(long nl, long nh);
unsigned char *cvector(long nl, long nh);
unsigned long *lvector(long nl, long nh);
double *dvector(long nl, long nh);
double **matrix(long nrl, long nrh, long ncl, long nch);
double **dmatrix(long nrl, long nrh, long ncl, long nch);
int **imatrix(long nrl, long nrh, long ncl, long nch);
char **cmatrix(long nrl, long nrh, long ncl, long nch);
double **submatrix(double **a, long oldrl, long oldrh, long oldcl, long oldch,
	long newrl, long newcl);
double **convert_matrix(double *a, long nrl, long nrh, long ncl, long nch);
double ***d3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
void free_vector(double *v, long nl, long nh);
void free_ivector(int *v, long nl, long nh);
void free_cvector(unsigned char *v, long nl, long nh);
void free_lvector(unsigned long *v, long nl, long nh);
void free_dvector(double *v, long nl, long nh);
void free_matrix(double **m, long nrl, long nrh, long ncl, long nch);
void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch);
void free_imatrix(int **m, long nrl, long nrh, long ncl, long nch);
void free_cmatrix(char **m, long nrl, long nrh, long ncl, long nch);
void free_submatrix(double **b, long nrl, long nrh, long ncl, long nch);
void free_convert_matrix(double **b, long nrl, long nrh, long ncl, long nch);
void free_d3tensor(double ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh);
#include <stdio.h>
void Choldc(Bandmatrix *a, int n, double p[]);
void Cholsl(Bandmatrix *a, int n, double p[], double b[], double x[]);
void cmat2fvec(double **cmat,long n,long m,double *fvec);
