#include <stdlib.h>
#include <iostream>
#include <fstream>

#include "../nr.h"
#include "../def.h"

using namespace std;


void setMesh(GlobExp *ex,Glob *globs,long expNr)
{
  long i,nPoints=ex[expNr].nPoints;
  
  ex[expNr].mesh=dvector(1,nPoints);
  ex[expNr].mesh[1]= ex[expNr].fitstart;
  ex[expNr].mesh[nPoints]= ex[expNr].fitend;

  if (globs->noMeasurements==FALSE) 
    {         
      // mesh at data points
      if (ex[expNr].nMeasure < nPoints) 
	{
	  cerr << "Too few measurements to construct mesh\n";
	  exit(1);
	}
      for (i=2; i < nPoints; ++i)
	ex[expNr].mesh[i]=ex[expNr].xMeasure[ex[expNr].firstMeasure+int(double((i-1)*(ex[expNr].nMeasure-1))/double(nPoints-1))];
    } 
  else 
    {        
      // evenly spaced mesh
      for (i=2; i < nPoints; ++i)
	ex[expNr].mesh[i]=ex[expNr].fitstart+(ex[expNr].fitend-ex[expNr].fitstart)*double(i-1)/double(nPoints-1);
    }
}
